﻿using System;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;

namespace TerrianGen
{
    public partial class Form1
    {

        public Graphics g;
        public SolidBrush brush = new SolidBrush(Color.Red);
        public Font myfont = new Font("Century", 10f, FontStyle.Italic);
        public string fname1, fname2, fname3, fname0, fname4, fname5, fname6, fname7, fname8, fname9, str1;
        public Pen pen = new Pen(Color.Black, 2f);
        public string FileName, Mapname, Harbor, Dirname;
        public int dot = 2;
        public int crtx, crty, i, j;
        public int xc, yc, xc1, yc1;
        public int proce_num, dkiii, ppx, ppy, plotYN, layoutcount;
        public int ix1, iy1, ix2, iy2;
        public double x1, x2, y1, y2;
        public double dxGrid, dyGrid, distance;
        public int dki, layoutline_renew, layoutline_append;
        public int NxGrid, NyGrid, ix, iy, dkii, xi, yi;
        public double lati_x, long_y, x_length, y_length, Xscale, Yscale, dep, depStart, quayHeight;
        public double[,] Depth;
        public string str, D, num_area, ratio;
        public int contourline_renew, contourline_append, procedure;
        public int layoutlne_renew, layoutlne_append;
        public double dis, c1, c2, indexD, zz, cutoff, ave;
        public int contourline, layoutline;
        public double xr_a, yr_a, r1, r2, tx, ty, depth_xy;
        public string[] substr;

        public int[] layout_dki = new int[51], contour_dki = new int[201], quaynode_dki = new int[51];
        public int[,] x_layout = new int[51, 1001], y_layout = new int[51, 1001];
        public int[,] x_quaydepth = new int[51, 1001], y_quaydepth = new int[51, 1001], x_quaynode = new int[51, 1001], y_quaynode = new int[51, 1001];
        public int[,] x_contour = new int[201, 1001], y_contour = new int[201, 1001];
        public double[,] z_layout = new double[51, 1001], z_contour = new double[201, 1001], z_quaydepth = new double[51, 1001], z_quaynode = new double[51, 1001];

        public double x, y, z, Xe, Ye, Ze, a, b, c, z1, xx, yy;
        public int xx1, yy1, xx2, yy2;
        public int Sx0, Sy0, Sx, Sy;
        public double R;
        public double Dummy;
        public double Ls, Le;
        public object gr = 9.81d;
        public double ratio1 = 10d;
        public double time;
        public double retZ, theta, phi;
        public double SinTheta, CosTheta, SinPhi, CosPhi, STheta, CTheta;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            g = PictureBox1.CreateGraphics();
            g.Clear(PictureBox1.BackColor);
        }

        private void Bt_perspective_Click(object sender, EventArgs e)
        {
            Perspective();
        }
        private void Perspective()
        {

            TerrianGenData();
            g.Clear(PictureBox1.BackColor);
            Le = double.Parse(Lee.Text);
            Ls = double.Parse(Lss.Text);
            int nmax = 1000;
            theta = double.Parse(Thetaa.Text);
            theta = Math.PI * theta / 180d;
            phi = double.Parse(Phii.Text);
            phi = Math.PI * phi / 180d;

            Sx0 = 0; // crtx / 2
            Sy0 = 0; // crty / 2

            SinTheta = Math.Sin(theta);
            SinPhi = Math.Sin(phi);
            CosTheta = Math.Cos(theta);
            CosPhi = Math.Cos(phi);
            STheta = Math.Sin(-theta);
            CTheta = Math.Cos(-theta);

            double[,] meshX = new double[101, nmax + 1], meshY = new double[101, nmax + 1];
            double[] max = new double[nmax + 1], min = new double[nmax + 1];
            // 港池透視

            // 港池
            pen.Width = 3f;
            pen.Color = Color.Black;
            if (layoutline != 0)
            {
                var loopTo = layoutline;
                for (i = 1; i <= loopTo; i++)
                {
                    str = i.ToString();
                    fname6 = Mapname + "_" + str + ".layout";
                    FileSystem.FileOpen(2, fname6, OpenMode.Input);
                    var loopTo1 = layout_dki[i];
                    for (dki = 1; dki <= loopTo1; dki++)
                    {
                        str = FileSystem.LineInput(2);
                        substr = Strings.Split(str, ",");
                        x_layout[i, dki] = (int)Math.Round(Conversion.Val(substr[0]));
                        y_layout[i, dki] = (int)Math.Round(Conversion.Val(substr[1]));
                        z_layout[i, dki] = Conversion.Val(substr[2]);
                    }
                    FileSystem.FileClose(2);
                }
                var loopTo2 = layoutline;
                for (ix = 1; ix <= loopTo2; ix++)
                {
                    var loopTo3 = layout_dki[ix];
                    for (dki = 1; dki <= loopTo3; dki++)
                    {
                        x1 = -x_layout[ix, dki];
                        y1 = y_layout[ix, dki];
                        z1 = z_layout[ix, dki] * ratio1;
                        xx = x1 * CTheta - y1 * STheta;       // 回轉theta消除畫面傾斜
                        yy = x1 * STheta + y1 * CTheta;
                        Xe = -xx * SinTheta + yy * CosTheta;
                        Ye = -xx * CosTheta * SinPhi - yy * SinTheta * CosPhi + z1 * SinPhi;
                        Ze = -xx * CosTheta * SinPhi - yy * SinTheta * SinPhi - z1 * CosPhi + Le;
                        Sx = (int)Math.Round(Sx0 + Ls * Xe / Ze);
                        Sy = (int)Math.Round(Sy0 - Ls * Ye / Ze);
                        meshX[ix, dki] = Sx;
                        meshY[ix, dki] = Sy;
                    }
                }

                var loopTo4 = layoutline;
                for (ix = 1; ix <= loopTo4; ix++)
                {
                    var loopTo5 = layout_dki[ix];
                    for (dki = 2; dki <= loopTo5; dki++)
                    {
                        xx1 = (int)Math.Round(meshX[ix, dki - 1]);
                        yy1 = (int)Math.Round(meshY[ix, dki - 1]);
                        xx2 = (int)Math.Round(meshX[ix, dki]);
                        yy2 = (int)Math.Round(meshY[ix, dki]);
                        g.DrawLine(pen, xx1, yy1, xx2, yy2);
                    }
                }
            }
            pen.Color = Color.LightGreen;
            pen.Width = 1f;
            dot = 2;
            int yn = 1;
            if (yn == 2)
            {
                // 等深線
                if (contourline != 0)
                {
                    var loopTo6 = contourline;
                    for (i = 1; i <= loopTo6; i++)
                    {
                        str = i.ToString();
                        fname8 = Mapname + "_" + str + ".contour";
                        FileSystem.FileOpen(2, fname8, OpenMode.Input);
                        var loopTo7 = contour_dki[i];
                        for (dki = 1; dki <= loopTo7; dki++)
                        {
                            str = FileSystem.LineInput(2);
                            substr = Strings.Split(str, ",");
                            x_contour[i, dki] = (int)Math.Round(Conversion.Val(substr[0]));
                            y_contour[i, dki] = (int)Math.Round(Conversion.Val(substr[1]));
                            z_contour[i, dki] = Conversion.Val(substr[2]);
                        }
                        FileSystem.FileClose(2);
                    }
                    var loopTo8 = contourline;
                    for (ix = 1; ix <= loopTo8; ix++)
                    {
                        var loopTo9 = contour_dki[ix];
                        for (dki = 1; dki <= loopTo9; dki++)
                        {
                            x1 = -x_contour[ix, dki];
                            y1 = y_contour[ix, dki];
                            z1 = -z_contour[ix, dki] * ratio1;
                            xx = x1 * CTheta - y1 * STheta;    // 回轉theta消除畫面傾斜
                            yy = x1 * STheta + y1 * CTheta;
                            Xe = -xx * SinTheta + yy * CosTheta;
                            Ye = -xx * CosTheta * SinPhi - yy * SinTheta * CosPhi + z1 * SinPhi;
                            Ze = -xx * CosTheta * SinPhi - yy * SinTheta * SinPhi - z1 * CosPhi + Le;
                            Sx = (int)Math.Round(Sx0 + Ls * Xe / Ze);
                            Sy = (int)Math.Round(Sy0 - Ls * Ye / Ze);
                            meshX[ix, dki] = Sx;
                            meshY[ix, dki] = Sy;
                        }
                    }
                    var loopTo10 = contourline;
                    for (ix = 1; ix <= loopTo10; ix++)
                    {
                        var loopTo11 = contour_dki[ix];
                        for (dki = 2; dki <= loopTo11; dki++)
                        {
                            xx1 = (int)Math.Round(meshX[ix, dki - 1]);
                            yy1 = (int)Math.Round(meshY[ix, dki - 1]);
                            xx2 = (int)Math.Round(meshX[ix, dki]);
                            yy2 = (int)Math.Round(meshY[ix, dki]);
                            g.DrawLine(pen, xx1, yy1, xx2, yy2);
                        }
                    }
                }
            }
        }
        private void Button1_Click(object sender, EventArgs e)
        {
            // 基本資料設定
            FileName = Fname.Text;
            PictureBox1.Image = Image.FromFile(FileName);
            Mapname = Map.Text;
            Dirname = Folder.Text;
            TerrianGen.My.MyProject.Computer.FileSystem.CreateDirectory(Dirname);
            // 初期化
            xc = 0;
            yc = 0;
            dki = 0;

            str1 = Interaction.InputBox("是：1 否：0", "新案第1次資料建立？", 0.ToString());
            if (string.IsNullOrEmpty(str1) | Strings.Len(Strings.Trim(str1)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            if (Conversion.Val(str1) == 0d)
            {
                TerrianGenData();
            }
            if (Conversion.Val(str1) == 1d)
            {
                x_length = double.Parse(Xlength.Text);                       // 海圖實際尺寸(m)
                y_length = double.Parse(Ylength.Text);
                crtx = int.Parse(ScreenX.Text);                          // 水域 CRT X 軸 DOT 數
                crty = int.Parse(ScreenY.Text);                          // 水域 CRT Y 軸 DOT 數
                Xscale = x_length / crtx;
                Yscale = y_length / crty;
                // NxGrid、dx自動計算
                NyGrid = int.Parse(GridY.Text);
                dyGrid = crty / (double)(NyGrid - 1);
                dxGrid = dyGrid * (x_length / y_length);
                NxGrid = (int)(crtx / (long)Math.Round(dxGrid) + 1L);
                dxGrid = crtx / (double)(NxGrid - 1);

                Depth = new double[NxGrid + 1, NyGrid + 1];

                contourline = 0;
                layoutline = 0;
                for (i = 1; i <= 10; i++)
                {
                    layout_dki[i] = 0;
                    quaynode_dki[i] = 0;
                }
                for (i = 1; i <= 100; i++)
                    contour_dki[i] = 0;
                DataSave();
            }

            str = Interaction.InputBox("建立了？ 1：即可直接使用海圖  尚未建立記得要建立 ： 0", "網格水深建立了？", 1.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            if (Conversion.Val(str) == 1d)
            {
                TerrianGenData();
                Depth = new double[NxGrid + 1, NyGrid + 1];
                fname2 = Mapname + ".grid";
                FileSystem.FileOpen(2, fname2, OpenMode.Input);
                var loopTo = NxGrid;
                for (ix = 1; ix <= loopTo; ix++)
                {
                    var loopTo1 = NyGrid;
                    for (iy = 1; iy <= loopTo1; iy++)
                    {
                        str = FileSystem.LineInput(2);
                        substr = Strings.Split(str, ",");
                        Depth[ix, iy] = Conversion.Val(substr[2]);
                    }
                }
                FileSystem.FileClose(2);
            }

        }
        private void PictureBox1_MouseDown(object sender, MouseEventArgs e)
        {

            if (e.Button == MouseButtons.Right)
            {
                xc = -1;
                MessageBox.Show("在起始點按滑鼠左鍵2次");
            }
            else if (xc == -1)
            {
                xc = e.X;
                yc = e.Y;                    // 設定起始點
                pen.Width = 2f;
                pen.Color = Color.Green;
                brush.Color = Color.Black;
                dot = 5;
            }
            else
            {
                if (proce_num == 1)                  // 港池配置新案
                {
                    g.FillEllipse(brush, e.X, e.Y, dot, dot);
                    if (Interaction.MsgBox("滑鼠鍵入位置是否正確？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    {
                        goto harbor1ok;
                    }
                    else
                    {
                        MessageBox.Show("在正確點按滑鼠左鍵");
                        brush.Color = PictureBox1.BackColor;
                        g.FillEllipse(brush, e.X, e.Y, dot, dot);
                        goto harbor1;
                    }

harbor1ok:
                    ;

                    g.DrawLine(pen, xc, yc, e.X, e.Y);
                    g.FillEllipse(brush, xc, yc, dot, dot);
                    xc = e.X;
                    yc = e.Y;
                    dki += 1;
                    x_layout[layoutline, dki] = xc;
                    y_layout[layoutline, dki] = yc;
                    str = Interaction.InputBox("鍵入該點水深(m)", "鍵入該點水深(m)，海岸線或外海防波堤為該點水深，港內碼頭為設計水深：");
                    if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
                    {
                        if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                            return;
                    }
                    z_layout[layoutline, dki] = -Conversion.Val(str);
                    FileSystem.PrintLine(2, xc + "," + yc + "," + -Conversion.Val(str) + "," + dki);
                    CooriX.Text = Strings.Format(xc, "###0");
                    CooriY.Text = Strings.Format(yc, "###0");
                    WaterDepth.Text = Strings.Format(-Conversion.Val(str), "####.##");

                    layout_dki[layoutline] = dki;
                    tb_number.Text = dki.ToString();
                    DataSave();
                    layoutcount = layoutline;
                    procedure = 11;
harbor1:
                    ;

                }

                if (proce_num == 2)                  // 港池配置追加例如增建離岸堤
                {

                    g.FillEllipse(brush, e.X, e.Y, dot, dot);
                    if (Interaction.MsgBox("滑鼠鍵入位置是否正確？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    {
                        goto harbor2ok;
                    }
                    else
                    {
                        MessageBox.Show("在正確點按滑鼠左鍵");
                        brush.Color = PictureBox1.BackColor;
                        g.FillEllipse(brush, e.X, e.Y, dot, dot);
                        goto harbor2;
                    }

harbor2ok:
                    ;

                    g.DrawLine(pen, xc, yc, e.X, e.Y);
                    g.FillEllipse(brush, xc, yc, dot, dot);
                    xc = e.X;
                    yc = e.Y;
                    dki += 1;
                    x_layout[layoutline, dki] = xc;
                    y_layout[layoutline, dki] = yc;
                    str = Interaction.InputBox("鍵入該點水深(m)", "鍵入該點水深(m)，海岸線或外海防波堤為該點水深，港內碼頭為設計水深：");
                    if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
                    {
                        if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                            return;
                    }
                    z_layout[layoutline, dki] = -Conversion.Val(str);
                    FileSystem.PrintLine(2, xc + "," + yc + "," + -Conversion.Val(str) + "," + dki);
                    CooriX.Text = Strings.Format(xc, "###0");
                    CooriY.Text = Strings.Format(yc, "###0");
                    WaterDepth.Text = Strings.Format(-Conversion.Val(str), "####.##");

                    layout_dki[layoutline] = dki;
                    tb_number.Text = dki.ToString();
                    DataSave();
                    layoutcount = layoutline;
                    procedure = 11;
harbor2:
                    ;

                }

                if (proce_num == 3)                  // 港池配置修改例如防波堤延長
                {
                    brush.Color = Color.Black;
                    g.FillEllipse(brush, e.X, e.Y, dot, dot);
                    if (Interaction.MsgBox("滑鼠鍵入位置是否正確？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    {
                        goto harbor3ok;
                    }
                    else
                    {
                        MessageBox.Show("在正確點按滑鼠左鍵");
                        brush.Color = PictureBox1.BackColor;
                        g.FillEllipse(brush, e.X, e.Y, dot, dot);
                        goto harbor3;
                    }

harbor3ok:
                    ;

                    g.DrawLine(pen, xc, yc, e.X, e.Y);
                    g.FillEllipse(brush, xc, yc, dot, dot);
                    xc = e.X;
                    yc = e.Y;
                    dki += 1;
                    x_layout[layoutline, dki] = xc;
                    y_layout[layoutline, dki] = yc;
                    str = Interaction.InputBox("鍵入該點水深(m)", "鍵入該點水深(m)，海岸線或外海防波堤為該點水深，港內碼頭為設計水深：");
                    if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
                    {
                        if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                            return;
                    }
                    z_layout[layoutline, dki] = -Conversion.Val(str);
                    FileSystem.PrintLine(2, xc + "," + yc + "," + -Conversion.Val(str) + "," + dki);
                    CooriX.Text = Strings.Format(xc, "###0");
                    CooriY.Text = Strings.Format(yc, "###0");
                    WaterDepth.Text = Strings.Format(-Conversion.Val(str), "####.##");
                    MessageBox.Show("在下1點按滑鼠左鍵，結束時按「單項確定」");
                    layout_dki[layoutline_renew] = dki;
                    tb_number.Text = dki.ToString();
                    DataSave();
                    layoutcount = layoutline;
                    procedure = 11;
harbor3:
                    ;

                }

                if (proce_num == 4)     // 等深線新案
                {

                    pen.Width = 1f;
                    pen.Color = Color.Green;
                    g.DrawLine(pen, xc, yc, e.X, e.Y);
                    dki += 1;
                    xc = e.X;
                    yc = e.Y;
                    x1 = xc * Xscale;
                    y1 = yc * Yscale;
                    if (dki == 2)
                    {
                        str = contourline.ToString();
                        brush.Color = Color.LightGray;
                        g.DrawString(str, myfont, brush, xc, yc);
                    }
                    if (dki == 10)
                    {
                        brush.Color = Color.Brown;
                        g.DrawString(D, myfont, brush, xc, yc);
                    }
                    dep = Conversion.Val(D);
                    x_contour[contourline, dki] = xc;
                    y_contour[contourline, dki] = yc;
                    z_contour[contourline, dki] = dep;
                    FileSystem.PrintLine(2, xc + "," + yc + "," + D + "," + dki);
                    CooriX.Text = Strings.Format(xc, "###0");
                    CooriY.Text = Strings.Format(yc, "###0");

                    contour_dki[contourline] = dki;
                    tb_number.Text = dki.ToString();
                    DataSave();

                }

                if (proce_num == 5)     // 等深線追加
                {

                    pen.Width = 1f;
                    pen.Color = Color.Green;
                    g.DrawLine(pen, xc, yc, e.X, e.Y);
                    dki += 1;
                    xc = e.X;
                    yc = e.Y;
                    x1 = xc * Xscale;
                    y1 = yc * Yscale;
                    if (dki == 2)
                    {
                        str = contourline.ToString();
                        brush.Color = Color.LightGray;
                        g.DrawString(str, myfont, brush, xc, yc);
                    }
                    if (dki == 10)
                    {
                        brush.Color = Color.Brown;
                        g.DrawString(D, myfont, brush, xc, yc);
                    }
                    dep = Conversion.Val(D);
                    x_contour[contourline, dki] = xc;
                    y_contour[contourline, dki] = yc;
                    z_contour[contourline, dki] = dep;
                    FileSystem.PrintLine(2, xc + "," + yc + "," + D + "," + dki);
                    CooriX.Text = Strings.Format(xc, "###0");
                    CooriY.Text = Strings.Format(yc, "###0");

                    contour_dki[contourline] = dki;
                    tb_number.Text = dki.ToString();
                    DataSave();
                }

                if (proce_num == 6)     // 等深線修改
                {

                    pen.Width = 1f;
                    pen.Color = Color.Green;
                    g.DrawLine(pen, xc, yc, e.X, e.Y);
                    dki += 1;
                    xc = e.X;
                    yc = e.Y;
                    x1 = xc * Xscale;
                    y1 = yc * Yscale;
                    if (dki == 2)
                    {
                        str = contourline_renew.ToString();
                        brush.Color = Color.LightGray;
                        g.DrawString(str, myfont, brush, xc, yc);
                    }
                    if (dki == 10)
                    {
                        brush.Color = Color.Brown;
                        g.DrawString(D, myfont, brush, xc, yc);
                    }
                    dep = Conversion.Val(D);
                    x_contour[contourline_renew, dki] = xc;
                    y_contour[contourline_renew, dki] = yc;
                    z_contour[contourline_renew, dki] = dep;

                    FileSystem.PrintLine(2, xc + "," + yc + "," + D + "," + dki);

                    CooriX.Text = Strings.Format(xc, "###0");
                    CooriY.Text = Strings.Format(yc, "###0");

                    contour_dki[contourline_renew] = dki;
                    tb_number.Text = dki.ToString();
                    DataSave();
                }

                if (proce_num == 10)     // 任意水深
                {

                    g.Clear(PictureBox1.BackColor);
                    // 網格線
                    pen.Color = Color.LightGray;
                    pen.Width = 1f;
                    var loopTo = NxGrid - 1;
                    for (ix = 0; ix <= loopTo; ix++)
                    {
                        xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                        g.DrawLine(pen, xi, 0, xi, crty);
                    }
                    var loopTo1 = NyGrid - 1;
                    for (iy = 0; iy <= loopTo1; iy++)
                    {
                        yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                        g.DrawLine(pen, 0, yi, crtx, yi);
                    }

                    // 港池
                    if (layoutline != 0)
                    {
                        pen.Width = 3f;
                        pen.Color = Color.Black;

                        var loopTo2 = layoutline;
                        for (i = 1; i <= loopTo2; i++)
                        {
                            str = i.ToString();
                            fname6 = Mapname + "_" + str + ".layout";
                            FileSystem.FileOpen(2, fname6, OpenMode.Input);

                            var loopTo3 = layout_dki[i];
                            for (dki = 1; dki <= loopTo3; dki++)
                            {
                                str = FileSystem.LineInput(2);
                                substr = Strings.Split(str, ",");
                                x_layout[i, dki] = (int)Math.Round(Conversion.Val(substr[0]));
                                y_layout[i, dki] = (int)Math.Round(Conversion.Val(substr[1]));
                                z_layout[i, dki] = Conversion.Val(substr[2]);
                            }
                            FileSystem.FileClose(2);
                            var loopTo4 = layout_dki[i];
                            for (dki = 2; dki <= loopTo4; dki++)
                            {
                                ix1 = x_layout[i, dki - 1];
                                iy1 = y_layout[i, dki - 1];
                                ix2 = x_layout[i, dki];
                                iy2 = y_layout[i, dki];
                                g.DrawLine(pen, ix1, iy1, ix2, iy2);
                            }

                        }
                    }

                    // 等深線
                    if (contourline != 0)
                    {
                        pen.Width = 1f;
                        dot = 2;
                        pen.Color = Color.LightGreen;

                        var loopTo5 = contourline;
                        for (i = 0; i <= loopTo5; i++)
                        {
                            str = i.ToString();
                            fname8 = Mapname + "_" + str + ".contour";
                            FileSystem.FileOpen(2, fname8, OpenMode.Input);

                            var loopTo6 = contour_dki[i];
                            for (dki = 1; dki <= loopTo6; dki++)
                            {
                                str = FileSystem.LineInput(2);
                                substr = Strings.Split(str, ",");
                                x_contour[i, dki] = (int)Math.Round(Conversion.Val(substr[0]));
                                y_contour[i, dki] = (int)Math.Round(Conversion.Val(substr[1]));
                                z_contour[i, dki] = Conversion.Val(substr[2]);
                                D = z_contour[i, dki].ToString();
                                xc = x_contour[i, dki];
                                yc = y_contour[i, dki];
                                dep = z_contour[i, dki];
                                if (dki == 5)
                                {
                                    brush.Color = Color.LightBlue;
                                    g.DrawString(D, myfont, brush, xc, yc);
                                }
                            }
                            FileSystem.FileClose(2);
                            var loopTo7 = contour_dki[i];
                            for (dki = 2; dki <= loopTo7; dki++)
                            {
                                ix1 = x_contour[i, dki - 1];
                                iy1 = y_contour[i, dki - 1];
                                ix2 = x_contour[i, dki];
                                iy2 = y_contour[i, dki];
                                g.DrawLine(pen, ix1, iy1, ix2, iy2);
                            }

                        }
                    }

                    dxGrid = crtx / (double)(NxGrid - 1);
                    dyGrid = crty / (double)(NyGrid - 1);
                    xc = e.X;
                    yc = e.Y;
                    x1 = xc * Xscale;
                    y1 = yc * Yscale;
                    i = (int)(xc / (long)Math.Round(dxGrid) + 1L);
                    j = (int)(yc / (long)Math.Round(dyGrid) + 1L);
                    xr_a = xc - (i - 1) * dxGrid;
                    yr_a = yc - (j - 1) * dyGrid;
                    tx = xr_a / dxGrid;
                    ty = yr_a / dyGrid;

                    if (xr_a >= 0d)
                        r1 = Depth[i, j] + tx * (Depth[i, j + 1] - Depth[i, j]);
                    if (xr_a < 0d)
                        r1 = Depth[i, j - 1] + tx * (Depth[i, j] - Depth[i, j - 1]);
                    if (yr_a >= 0d)
                        r2 = Depth[i + 1, j] + tx * (Depth[i + 1, j + 1] - Depth[i + 1, j]);
                    if (yr_a < 0d)
                        r2 = Depth[i, j] + tx * (Depth[i + 1, j] - Depth[i, j]);

                    depth_xy = Conversions.ToDouble(Strings.Format(r1 + ty * (r2 - r1), "####.#0"));

                    brush.Color = Color.Red;
                    dot = 3;
                    g.DrawString(depth_xy.ToString(), myfont, brush, xc, yc);
                    g.FillEllipse(brush, xc, yc, dot, dot);
                    brush.Color = Color.LightBlue;

                    CooriX.Text = Strings.Format(xc, "###0");
                    CooriY.Text = Strings.Format(yc, "###0");
                    WaterDepth.Text = Strings.Format(depth_xy, "####.##");
                }
            }
        }

        private void Harbornew_Click(object sender, EventArgs e)
        {
            proce_num = 1;   // 港池配置  離岸堤或多港池時layoutline>=2
            TerrianGenData();
            // 網格線
            pen.Color = Color.LightGray;
            pen.Width = 1f;
            var loopTo = NxGrid - 1;
            for (ix = 0; ix <= loopTo; ix++)
            {
                xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                g.DrawLine(pen, xi, 0, xi, crty);
            }
            var loopTo1 = NyGrid - 1;
            for (iy = 0; iy <= loopTo1; iy++)
            {
                yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                g.DrawLine(pen, 0, yi, crtx, yi);
            }

            layoutline += 1;
            str = layoutline.ToString();
            fname6 = Mapname + "_" + str + ".layout";
            FileSystem.FileOpen(2, fname6, OpenMode.Output);
            Harbornew.Enabled = true;
            Any.Enabled = false;
            Contour_new.Enabled = false;
            Endd.Enabled = true;
            All_end.Enabled = false;
            dki = 0;
            MessageBox.Show("在滑鼠區任意位置按滑鼠右鍵，啓動滑鼠鍵入功能");
        }

        private void Harborappend_Click(object sender, EventArgs e)
        {
            proce_num = 2;
            procedure = 1;

            TerrianGenData();

            // 繪製網格
            pen.Color = Color.LightGray;
            pen.Width = 1f;
            var loopTo = NxGrid - 1;
            for (ix = 0; ix <= loopTo; ix++)
            {
                xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                g.DrawLine(pen, xi, 0, xi, crty);
            }
            var loopTo1 = NyGrid - 1;
            for (iy = 0; iy <= loopTo1; iy++)
            {
                yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                g.DrawLine(pen, 0, yi, crtx, yi);
            }
            D = Interaction.InputBox("輸入欲追加離岸堤等檔編號", "選定欲追加離岸堤等配置，從資料夾或海圖覓得欲追加離岸堤等檔layout編號(最終編號+1)：");
            if (string.IsNullOrEmpty(D) | Strings.Len(Strings.Trim(D)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            layoutline_append = (int)Math.Round(Conversion.Val(D));
            layoutline += 1;
            str = layoutline_append.ToString();
            fname6 = Mapname + "_" + str + ".layout";
            FileSystem.FileOpen(2, fname6, OpenMode.Output);
            dki = 0;
            Harborappend.Visible = false;
            MessageBox.Show("在滑鼠區任意位置按滑鼠右鍵，啓動滑鼠鍵入功能");
        }

        private void Harborrepair_Click(object sender, EventArgs e)
        {
            proce_num = 3;
            procedure = 1;

            TerrianGenData();

            // 繪製網格
            pen.Color = Color.LightGray;
            pen.Width = 1f;
            var loopTo = NxGrid - 1;
            for (ix = 0; ix <= loopTo; ix++)
            {
                xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                g.DrawLine(pen, xi, 0, xi, crty);
            }
            var loopTo1 = NyGrid - 1;
            for (iy = 0; iy <= loopTo1; iy++)
            {
                yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                g.DrawLine(pen, 0, yi, crtx, yi);
            }

            str = Interaction.InputBox("輸入欲修改港池配置檔編號", "選定修改港池配置，從資料夾或海圖覓得欲修改港池配置檔layout編號：");
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            layoutline_renew = (int)Math.Round(Conversion.Val(str));

            str = layoutline_renew.ToString();
            fname6 = Mapname + "_" + str + ".layout";
            FileSystem.FileOpen(2, fname6, OpenMode.Output);

            dki = 0;
            MessageBox.Show("在滑鼠區任意位置按滑鼠右鍵，啓動滑鼠鍵入功能");
        }
        private void Contour_new_Click(object sender, EventArgs e)
        {

            proce_num = 4;
            procedure = 1;   // 等深線
            TerrianGenData();
            // 網格線
            pen.Color = Color.LightGray;
            pen.Width = 1f;
            var loopTo = NxGrid - 1;
            for (ix = 0; ix <= loopTo; ix++)
            {
                xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                g.DrawLine(pen, xi, 0, xi, crty);
            }
            var loopTo1 = NyGrid - 1;
            for (iy = 0; iy <= loopTo1; iy++)
            {
                yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                g.DrawLine(pen, 0, yi, crtx, yi);
            }
            contourline += 1;
            tb_contourline.Text = contourline.ToString();
            D = Interaction.InputBox("輸入等深線值水深：", "等深線值輸入");
            if (string.IsNullOrEmpty(D) | Strings.Len(Strings.Trim(D)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            str = contourline.ToString();
            fname8 = Mapname + "_" + str + ".contour";
            FileSystem.FileOpen(2, fname8, OpenMode.Output);

            Harbornew.Enabled = false;
            Any.Enabled = false;
            Contour_new.Enabled = true;
            Endd.Enabled = true;
            All_end.Enabled = false;
            // CrtCoor.Visible = True

            dki = 0;
            MessageBox.Show("在滑鼠區任意位置按滑鼠右鍵，啓動滑鼠鍵入功能");
        }
        private void Contour_append_Click(object sender, EventArgs e)
        {
            proce_num = 5;
            procedure = 1;

            TerrianGenData();

            // 繪製網格
            pen.Color = Color.LightGray;
            pen.Width = 1f;
            var loopTo = NxGrid - 1;
            for (ix = 0; ix <= loopTo; ix++)
            {
                xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                g.DrawLine(pen, xi, 0, xi, crty);
            }
            var loopTo1 = NyGrid - 1;
            for (iy = 0; iy <= loopTo1; iy++)
            {
                yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                g.DrawLine(pen, 0, yi, crtx, yi);
            }

            str = "選定" + ":" + "欲追加等深線";
            MessageBox.Show(str);
            str = Interaction.InputBox("從資料夾或海圖覓得最終等深線檔contour編號(最終編號 + 1)：", "輸入追加等深線檔編號");
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            contourline_append = (int)Math.Round(Conversion.Val(str));
            contourline += 1;
            tb_contourline.Text = contourline.ToString();
            D = Interaction.InputBox("輸入等深線值水深：", "等深線值輸入");
            if (string.IsNullOrEmpty(D) | Strings.Len(Strings.Trim(D)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            str = contourline_append.ToString();
            fname6 = Mapname + "_" + str + ".contour";
            FileSystem.FileOpen(2, fname6, OpenMode.Output);

            dki = 0;
            Contour_append.Visible = false;
            MessageBox.Show("在滑鼠區任意位置按滑鼠右鍵，啓動滑鼠鍵入功能");
        }

        private void Contour_repair_Click(object sender, EventArgs e)
        {
            proce_num = 6;
            procedure = 1;

            TerrianGenData();
            tb_contourline.Text = contourline.ToString();
            // 繪製網格
            pen.Color = Color.LightGray;
            pen.Width = 1f;
            var loopTo = NxGrid - 1;
            for (ix = 0; ix <= loopTo; ix++)
            {
                xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                g.DrawLine(pen, xi, 0, xi, crty);
            }
            var loopTo1 = NyGrid - 1;
            for (iy = 0; iy <= loopTo1; iy++)
            {
                yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                g.DrawLine(pen, 0, yi, crtx, yi);
            }

            str = "選定" + ":" + "重新建立第n條等深線";
            MessageBox.Show(str);
            str = Interaction.InputBox("從資料夾或海圖覓得欲重新建立等深線檔contour編號：", "輸入欲修正等深線檔編號");
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            contourline_renew = (int)Math.Round(Conversion.Val(str));

            D = Interaction.InputBox("輸入等深線值水深：", "等深線值輸入");
            if (string.IsNullOrEmpty(D) | Strings.Len(Strings.Trim(D)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            str = contourline_renew.ToString();
            fname6 = Mapname + "_" + str + ".contour";
            FileSystem.FileOpen(2, fname6, OpenMode.Output);

            dki = 0;
            MessageBox.Show("在滑鼠區任意位置按滑鼠右鍵，啓動滑鼠鍵入功能");
        }

        private void quayNode_Click(object sender, EventArgs e)
        {
            QuayNode();
        }
        private void QuayNode()
        {

            MessageBox.Show("開始執行自動建置港形邊界節點");

            TerrianGenData();
            int x1, x2, y1, y2, z1, z2, layoutNo;
            double dx, dy, dz, xx, yy, zz;
            // 網格線
            pen.Color = Color.LightGray;
            pen.Width = 1f;
            var loopTo = NxGrid - 1;
            for (ix = 0; ix <= loopTo; ix++)
            {
                xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                g.DrawLine(pen, xi, 0, xi, crty);
            }
            var loopTo1 = NyGrid - 1;
            for (iy = 0; iy <= loopTo1; iy++)
            {
                yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                g.DrawLine(pen, 0, yi, crtx, yi);
            }

layout:
            ;

            str = Interaction.InputBox("輸入港形線檔編號(原港形=1)", "選定港形線設定碼頭邊界點：", 1.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
                goto layout;
            }

            layoutNo = (int)Math.Round(Conversion.Val(str));

            fname5 = Mapname + "_" + str + ".layout";
            FileSystem.FileOpen(5, fname5, OpenMode.Input);

            var loopTo2 = layout_dki[layoutNo];
            for (i = 1; i <= loopTo2; i++)
            {
                str = FileSystem.LineInput(5);
                substr = Strings.Split(str, ",");
                x_layout[layoutNo, i] = (int)Math.Round(Conversion.Val(substr[0]));
                y_layout[layoutNo, i] = (int)Math.Round(Conversion.Val(substr[1]));
                z_layout[layoutNo, i] = Conversion.Val(substr[2]);
            }
            FileSystem.FileClose(5);

            pen.Color = Color.Red;
            brush.Color = Color.Black;
            pen.Width = 2f;
            dot = 5;
            x_quaynode[layoutNo, 1] = x_layout[layoutNo, 1];
            y_quaynode[layoutNo, 1] = y_layout[layoutNo, 1];
            z_quaynode[layoutNo, 1] = z_layout[layoutNo, 1];
            dki = 1;
            var loopTo3 = layout_dki[layoutNo] - 1;
            for (i = 1; i <= loopTo3; i++)
            {
                // If layoutNo > 1 And i = layout_dki(layoutNo) - 1 Then GoTo quay

                x1 = x_layout[layoutNo, i];
                y1 = y_layout[layoutNo, i];
                z1 = (int)Math.Round(z_layout[layoutNo, i]);
                x2 = x_layout[layoutNo, i + 1];
                y2 = y_layout[layoutNo, i + 1];
                z2 = (int)Math.Round(z_layout[layoutNo, i + 1]);
                g.DrawLine(pen, x1, y1, x2, y2);
                g.FillEllipse(brush, x1, y1, dot, dot);
quaydepth:
                ;

                str = Interaction.InputBox("該區間欲增加邊界節點數", "本區間是否加入邊界節點？ 否：輸入 0，是：輸入該區間欲增加邊界節點數？：");
                if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
                {
                    if (Interaction.MsgBox("未輸入資料是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                        return;
                    goto quaydepth;
                }

                int ino = (int)Math.Round(Conversion.Val(str));
                if (ino == 0)
                {
                    dki += 1;
                    x_quaynode[layoutNo, dki] = x_layout[layoutNo, i + 1];
                    y_quaynode[layoutNo, dki] = y_layout[layoutNo, i + 1];
                    z_quaynode[layoutNo, dki] = z_layout[layoutNo, i + 1];
                    x1 = x_quaynode[layoutNo, dki];
                    y1 = y_quaynode[layoutNo, dki];
                    g.FillEllipse(brush, x1, y1, dot, dot);
                }
                if (ino != 0)
                {
                    dx = (x2 - x1) / (double)(ino + 1);
                    dy = (y2 - y1) / (double)(ino + 1);
                    dz = (z2 - z1) / (double)(ino + 1);
                    var loopTo4 = ino;
                    for (j = 1; j <= loopTo4; j++)
                    {
                        dki += 1;
                        x_quaynode[layoutNo, dki] = (int)Math.Round(x_layout[layoutNo, i] + dx * j);
                        y_quaynode[layoutNo, dki] = (int)Math.Round(y_layout[layoutNo, i] + dy * j);
                        z_quaynode[layoutNo, dki] = z_layout[layoutNo, i] + dz * j;
                        x1 = x_quaynode[layoutNo, dki];
                        y1 = y_quaynode[layoutNo, dki];
                        g.FillEllipse(brush, x1, y1, dot, dot);
                    }
                    dki += 1;
                    x_quaynode[layoutNo, dki] = x_layout[layoutNo, i + 1];
                    y_quaynode[layoutNo, dki] = y_layout[layoutNo, i + 1];
                    z_quaynode[layoutNo, dki] = z_layout[layoutNo, i + 1];
                    x1 = x_quaynode[layoutNo, dki];
                    y1 = y_quaynode[layoutNo, dki];
                    g.FillEllipse(brush, x1, y1, dot, dot);
                }
                tb_number.Text = dki.ToString();
quay:
                ;
            }

            quaynode_dki[layoutNo] = dki;
            str = layoutNo.ToString();

            fname6 = Mapname + "_" + str + ".quaynode";
            FileSystem.FileOpen(6, fname6, OpenMode.Output);
            var loopTo5 = dki;
            for (i = 1; i <= loopTo5; i++)
            {
                xx = x_quaynode[layoutNo, i];
                yy = y_quaynode[layoutNo, i];
                zz = z_quaynode[layoutNo, i];
                FileSystem.PrintLine(6, xx + "," + yy + "," + zz + "," + i);
            }
            FileSystem.FileClose(6);
            DataSave();

            MessageBox.Show("港形邊界節點建置完成");

        }

        private void quayDepth_Click(object sender, EventArgs e)
        {
            QuayDepth();
        }
        private void QuayDepth()
        {

            MessageBox.Show("開始執行自動建置碼頭水深");

            TerrianGenData();
            int x1, x2, y1, y2, z1, z2, layoutNo;
            double dx, dy, dz, xx, yy, zz;
            // 網格線
            pen.Color = Color.LightGray;
            pen.Width = 1f;
            var loopTo = NxGrid - 1;
            for (ix = 0; ix <= loopTo; ix++)
            {
                xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                g.DrawLine(pen, xi, 0, xi, crty);
            }
            var loopTo1 = NyGrid - 1;
            for (iy = 0; iy <= loopTo1; iy++)
            {
                yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                g.DrawLine(pen, 0, yi, crtx, yi);
            }

layout:
            ;

            str = Interaction.InputBox("輸入港形線檔編號(原港形=1)", "選定港形線設定碼頭邊界水深：", 1.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
                goto layout;
            }

            layoutNo = (int)Math.Round(Conversion.Val(str));

            fname5 = Mapname + "_" + str + ".layout";
            FileSystem.FileOpen(5, fname5, OpenMode.Input);

            var loopTo2 = layout_dki[layoutNo];
            for (i = 1; i <= loopTo2; i++)
            {
                str = FileSystem.LineInput(5);
                substr = Strings.Split(str, ",");
                x_layout[layoutNo, i] = (int)Math.Round(Conversion.Val(substr[0]));
                y_layout[layoutNo, i] = (int)Math.Round(Conversion.Val(substr[1]));
                z_layout[layoutNo, i] = Conversion.Val(substr[2]);
            }
            FileSystem.FileClose(5);

            pen.Color = Color.Red;
            brush.Color = Color.Black;
            pen.Width = 2f;
            dot = 5;
            x_quaydepth[layoutNo, 1] = x_layout[layoutNo, 1];
            y_quaydepth[layoutNo, 1] = y_layout[layoutNo, 1];
            z_quaydepth[layoutNo, 1] = z_layout[layoutNo, 1];
            dki = 1;
            var loopTo3 = layout_dki[layoutNo] - 1;
            for (i = 1; i <= loopTo3; i++)
            {
                // If layoutNo > 1 And i = layout_dki(layoutNo) - 1 Then GoTo quay

                x1 = x_layout[layoutNo, i];
                y1 = y_layout[layoutNo, i];
                z1 = (int)Math.Round(z_layout[layoutNo, i]);
                x2 = x_layout[layoutNo, i + 1];
                y2 = y_layout[layoutNo, i + 1];
                z2 = (int)Math.Round(z_layout[layoutNo, i + 1]);
                g.DrawLine(pen, x1, y1, x2, y2);
                g.FillEllipse(brush, x1, y1, dot, dot);
quaydepth:
                ;

                str = Interaction.InputBox("該區間欲增加邊界節點數", "本區間是否加入邊界節點？ 否：輸入 0，是：輸入該區間欲增加邊界節點數？：");
                if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
                {
                    if (Interaction.MsgBox("未輸入資料是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                        return;
                    goto quaydepth;
                }

                int ino = (int)Math.Round(Conversion.Val(str));
                if (ino == 0)
                {
                    dki += 1;
                    x_quaydepth[layoutNo, dki] = x_layout[layoutNo, i + 1];
                    y_quaydepth[layoutNo, dki] = y_layout[layoutNo, i + 1];
                    z_quaydepth[layoutNo, dki] = z_layout[layoutNo, i + 1];
                    x1 = x_quaydepth[layoutNo, dki];
                    y1 = y_quaydepth[layoutNo, dki];
                    g.FillEllipse(brush, x1, y1, dot, dot);
                }
                if (ino != 0)
                {
                    dx = (x2 - x1) / (double)(ino + 1);
                    dy = (y2 - y1) / (double)(ino + 1);
                    dz = (z2 - z1) / (double)(ino + 1);
                    var loopTo4 = ino;
                    for (j = 1; j <= loopTo4; j++)
                    {
                        dki += 1;
                        x_quaydepth[layoutNo, dki] = (int)Math.Round(x_layout[layoutNo, i] + dx * j);
                        y_quaydepth[layoutNo, dki] = (int)Math.Round(y_layout[layoutNo, i] + dy * j);
                        z_quaydepth[layoutNo, dki] = z_layout[layoutNo, i] + dz * j;
                        x1 = x_quaydepth[layoutNo, dki];
                        y1 = y_quaydepth[layoutNo, dki];
                        g.FillEllipse(brush, x1, y1, dot, dot);
                    }
                    dki += 1;
                    x_quaydepth[layoutNo, dki] = x_layout[layoutNo, i + 1];
                    y_quaydepth[layoutNo, dki] = y_layout[layoutNo, i + 1];
                    z_quaydepth[layoutNo, dki] = z_layout[layoutNo, i + 1];
                    x1 = x_quaydepth[layoutNo, dki];
                    y1 = y_quaydepth[layoutNo, dki];
                    g.FillEllipse(brush, x1, y1, dot, dot);
                }
                tb_number.Text = dki.ToString();
quay:
                ;
            }

            contour_dki[0] = dki;
            str = layoutNo.ToString();

            fname6 = Mapname + "_" + "0" + ".contour";
            FileSystem.FileOpen(6, fname6, OpenMode.Output);
            var loopTo5 = dki;
            for (i = 1; i <= loopTo5; i++)
            {
                xx = x_quaydepth[layoutNo, i];
                yy = y_quaydepth[layoutNo, i];
                zz = z_quaydepth[layoutNo, i];
                x_contour[0, i] = (int)Math.Round(xx);
                y_contour[0, i] = (int)Math.Round(yy);
                z_contour[0, i] = zz;
                FileSystem.PrintLine(6, xx + "," + yy + "," + zz + "," + i);
            }
            FileSystem.FileClose(6);

            DataSave();

            MessageBox.Show("港形水深建置完成");

        }
        private void DataSave()
        {

            All_end.Visible = true;
            Endd.Visible = true;

            fname1 = Mapname + ".chart";
            FileSystem.FileOpen(1, fname1, OpenMode.Output);
            FileSystem.PrintLine(1, x_length + "," + "x_length");
            FileSystem.PrintLine(1, y_length + "," + "y_length");
            FileSystem.PrintLine(1, crtx + "," + "crtx");
            FileSystem.PrintLine(1, crty + "," + "crty");
            FileSystem.PrintLine(1, NyGrid + "," + "NyGrid");
            FileSystem.PrintLine(1, depStart + "," + "depStart");
            FileSystem.PrintLine(1, layoutline + "," + "layoutline");
            if (layoutline != 0)
            {
                var loopTo = layoutline;
                for (i = 1; i <= loopTo; i++)
                    FileSystem.PrintLine(1, layout_dki[i] + "," + "layout_dki(" + i + ")");
                var loopTo1 = layoutline;
                for (i = 1; i <= loopTo1; i++)
                    FileSystem.PrintLine(1, quaynode_dki[i] + "," + "quaynode_dki(" + i + ")");
            }
            FileSystem.PrintLine(1, contourline + "," + "contourline");
            if (contourline != 0)
            {
                var loopTo2 = contourline;
                for (i = 1; i <= loopTo2; i++)
                    FileSystem.PrintLine(1, contour_dki[i] + "," + "contour_dki(" + i + ")");
            }

            FileSystem.FileClose(1);

        }

        private void TerrianGenData()
        {

            fname1 = Mapname + ".chart";
            FileSystem.FileOpen(1, fname1, OpenMode.Input);
            str = FileSystem.LineInput(1);
            substr = Strings.Split(str, ",");
            x_length = Conversion.Val(substr[0]);
            str = FileSystem.LineInput(1);
            substr = Strings.Split(str, ",");
            y_length = Conversion.Val(substr[0]);
            str = FileSystem.LineInput(1);
            substr = Strings.Split(str, ",");
            crtx = (int)Math.Round(Conversion.Val(substr[0]));
            str = FileSystem.LineInput(1);
            substr = Strings.Split(str, ",");
            crty = (int)Math.Round(Conversion.Val(substr[0]));
            str = FileSystem.LineInput(1);
            substr = Strings.Split(str, ",");
            NyGrid = (int)Math.Round(Conversion.Val(substr[0]));
            str = FileSystem.LineInput(1);
            substr = Strings.Split(str, ",");
            depStart = Conversion.Val(substr[0]);
            str = FileSystem.LineInput(1);
            substr = Strings.Split(str, ",");
            layoutline = (int)Math.Round(Conversion.Val(substr[0]));
            if (layoutline != 0)
            {
                var loopTo = layoutline;
                for (i = 1; i <= loopTo; i++)
                {
                    str = FileSystem.LineInput(1);
                    substr = Strings.Split(str, ",");
                    layout_dki[i] = (int)Math.Round(Conversion.Val(substr[0]));
                }
                var loopTo1 = layoutline;
                for (i = 1; i <= loopTo1; i++)
                {
                    str = FileSystem.LineInput(1);
                    substr = Strings.Split(str, ",");
                    quaynode_dki[i] = (int)Math.Round(Conversion.Val(substr[0]));
                }
            }
            str = FileSystem.LineInput(1);
            substr = Strings.Split(str, ",");
            contourline = (int)Math.Round(Conversion.Val(substr[0]));
            if (contourline != 0)
            {
                var loopTo2 = contourline;
                for (i = 1; i <= loopTo2; i++)
                {
                    str = FileSystem.LineInput(1);
                    substr = Strings.Split(str, ",");
                    contour_dki[i] = (int)Math.Round(Conversion.Val(substr[0]));
                }
            }

            FileSystem.FileClose(1);

            dyGrid = crty / (double)(NyGrid - 1);
            dxGrid = dyGrid * (x_length / y_length);
            NxGrid = (int)(crtx / (long)Math.Round(dxGrid) + 1L);
            dxGrid = crtx / (double)(NxGrid - 1);

            GridY.Text = NyGrid.ToString();
            GridX.Text = NxGrid.ToString();
            Xlength.Text = x_length.ToString();
            Ylength.Text = y_length.ToString();
            ScreenX.Text = crtx.ToString();
            ScreenY.Text = crty.ToString();
            tb_depStart.Text = depStart.ToString();
            tb_layoutline.Text = layoutline.ToString();
            tb_contourline.Text = contourline.ToString();

        }

        private void Grid_Click(object sender, EventArgs e)
        {
            // 格點水深
            PlotContour();
            TerrianGenData();

            str = Interaction.InputBox("是否變更網格間隔？", "是：1 不是：0", 0.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }

            if (Conversion.Val(str) == 1d)
            {
                str = Interaction.InputBox("輸入NyGrid值：", "NyGrid值輸入");
                if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(D)) == 0)
                {
                    if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                        return;
                }
                NyGrid = (int)Math.Round(Conversion.Val(str));
                dyGrid = crty / (double)(NyGrid - 1);
                dxGrid = dyGrid * (x_length / y_length);
                NxGrid = (int)(crtx / (long)Math.Round(dxGrid) + 1L);
                dxGrid = crtx / (double)(NxGrid - 1);

                GridY.Text = NyGrid.ToString();
                GridX.Text = NxGrid.ToString();
                DataSave();
                PlotContour();
            }

            Depth = new double[NxGrid + 1, NyGrid + 1];
            // 全部網格水深初期值預設為1000，以便爾後判定陸域或海域
            var loopTo = NxGrid;
            for (ix = 0; ix <= loopTo; ix++)
            {
                var loopTo1 = NyGrid;
                for (iy = 0; iy <= loopTo1; iy++)
                    Depth[ix, iy] = 1000d;
            }

            dyGrid = crty / (double)(NyGrid - 1);
            dxGrid = crtx / (double)(NxGrid - 1);

            Harbornew.Enabled = false;
            Any.Enabled = true;
            Contour_new.Enabled = false;
            Endd.Enabled = true;
            All_end.Enabled = true;
            Grid.Enabled = true;

            // 網格線
            pen.Color = Color.LightGray;
            pen.Width = 1f;
            var loopTo2 = NxGrid - 1;
            for (ix = 0; ix <= loopTo2; ix++)
            {
                xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                g.DrawLine(pen, xi, 0, xi, crty);
            }
            var loopTo3 = NyGrid - 1;
            for (iy = 0; iy <= loopTo3; iy++)
            {
                yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                g.DrawLine(pen, 0, yi, crtx, yi);
            }

            // 開始計算網格水深
            pen.Color = Color.Blue;
            pen.Width = 1f;
            D = Interaction.InputBox("輸入起始區水深：", "水深輸入");
            if (string.IsNullOrEmpty(D) | Strings.Len(Strings.Trim(D)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            dep = -Conversion.Val(D);
            depStart = dep;
            int N = 2;
            var loopTo4 = N;
            for (ix = 1; ix <= loopTo4; ix++)
            {
                xi = (int)Math.Round((ix - 1) * dxGrid);
                var loopTo5 = NyGrid;
                for (iy = 1; iy <= loopTo5; iy++)
                {
                    yi = (int)Math.Round((iy - 1) * dyGrid);
                    xc = xi;
                    yc = yi;
                    dot = 3;
                    brush.Color = Color.Green;
                    g.FillEllipse(brush, xc, yc, dot, dot);
                    Depth[ix, iy] = dep;
                    if (ix == 1 & iy == (NyGrid - 1) / 2)
                        g.DrawString(D, myfont, brush, xi, yi);
                }
            }

            ratio = Interaction.InputBox("內插距離倍率隨等深線疏密及網格間距大小而異宜試錯決定", "倍率(0.1～3) ", 0.2d.ToString());
            if (string.IsNullOrEmpty(ratio) | Strings.Len(Strings.Trim(ratio)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            distance = Conversion.Val(ratio);

            indexD = Math.Sqrt(dxGrid * dxGrid + dyGrid * dyGrid) * distance;

            str = Interaction.InputBox("判斷終止基準的內插距離倍率，隨等深線疏密及網格間距大小而異宜試錯決定", "終止內插基準倍率", 2.0d.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            cutoff = Conversion.Val(str);

            // 若有適當海底地形電子數據可供直接使用，下列另議

            var loopTo6 = NxGrid;
            for (ix = N + 1; ix <= loopTo6; ix++)
            {
                xi = (int)Math.Round((ix - 1) * dxGrid);
                var loopTo7 = NyGrid;
                for (iy = 1; iy <= loopTo7; iy++)
                {
                    yi = (int)Math.Round((iy - 1) * dyGrid);
                    xc = xi;
                    yc = yi;

                    c1 = 0d;
                    c2 = 0d;
                    dkii = 0;
                    var loopTo8 = contourline;
                    for (i = 0; i <= loopTo8; i++)
                    {
                        var loopTo9 = contour_dki[i];
                        for (dki = 1; dki <= loopTo9; dki++)
                        {
                            xx = x_contour[i, dki];
                            yy = y_contour[i, dki];
                            zz = -z_contour[i, dki];
                            dis = Math.Sqrt((xx - xc) * (xx - xc) + (yy - yc) * (yy - yc));
                            if (dis <= indexD)
                            {
                                dkii += 1;
                                c1 += zz / dis;
                                c2 += 1d / dis;
                            }
                        }
                    }

                    if (dkii != 0)
                    {
                        dep = c1 / c2;
                        dot = 3;
                        brush.Color = Color.Red;
                        g.FillEllipse(brush, xc, yc, dot, dot);
                    }

                    if (dkii == 0)
                    {
                        while (distance < cutoff)
                        {
                            distance += 0.1d;
                            indexD = Math.Sqrt(dxGrid * dxGrid + dyGrid * dyGrid) * distance;
                            c1 = 0d;
                            c2 = 0d;
                            dkiii = 0;
                            var loopTo10 = contourline;
                            for (i = 0; i <= loopTo10; i++)
                            {
                                var loopTo11 = contour_dki[i];
                                for (dki = 1; dki <= loopTo11; dki++)
                                {
                                    xx = x_contour[i, dki];
                                    yy = y_contour[i, dki];
                                    zz = -z_contour[i, dki];
                                    dis = Math.Sqrt((xx - xc) * (xx - xc) + (yy - yc) * (yy - yc));
                                    if (dis <= indexD)
                                    {
                                        dkiii += 1;
                                        c1 += zz / dis;
                                        c2 += 1d / dis;
                                    }
                                }
                            }

                            if (dkiii != 0)
                            {
                                dep = c1 / c2;
                                dot = 3;
                                brush.Color = Color.Blue;
                                g.FillEllipse(brush, xc, yc, dot, dot);
                                goto TerrianGen;
                            }
                            if (dkiii == 0)
                            {
                                dot = 3;
                                brush.Color = Color.Brown;
                                g.FillEllipse(brush, xc, yc, dot, dot);
                                dep = Depth[ix, iy];
                            }
                        }

TerrianGen:
                        ;

                        distance = Conversion.Val(ratio);
                        Depth[ix, iy] = dep;
                        dot = 3;
                        brush.Color = Color.Black;
                        g.FillEllipse(brush, xc, yc, dot, dot);
                    }
                    Depth[ix, iy] = dep;
                    CooriX.Text = Strings.Format(ix, "###0");
                    CooriY.Text = Strings.Format(iy, "###0");
                    WaterDepth.Text = Strings.Format(dep, "####.##");
                }
            }

            fname2 = Mapname + ".grid";
            FileSystem.FileOpen(2, fname2, OpenMode.Output);
            var loopTo12 = NxGrid;
            for (ix = 1; ix <= loopTo12; ix++)
            {
                var loopTo13 = NyGrid;
                for (iy = 1; iy <= loopTo13; iy++)
                {
                    D = Strings.Format(Depth[ix, iy], "0.00");
                    FileSystem.PrintLine(2, ix + "," + iy + "," + D + "," + "GridDepth");
                }
            }
            FileSystem.FileClose(2);

        }
        private void Any_Click(object sender, EventArgs e)
        {
            proce_num = 10;                 // 任意水深 
            Harbornew.Enabled = false;
            Any.Enabled = true;
            Contour_new.Enabled = false;
            Endd.Enabled = true;
            All_end.Enabled = false;

            TerrianGenData();

            fname2 = Mapname + ".grid";
            FileSystem.FileOpen(2, fname2, OpenMode.Input);
            var loopTo = NxGrid;
            for (ix = 1; ix <= loopTo; ix++)
            {
                var loopTo1 = NyGrid;
                for (iy = 1; iy <= loopTo1; iy++)
                {
                    str = FileSystem.LineInput(2);
                    substr = Strings.Split(str, ",");
                    Depth[ix, iy] = Conversion.Val(substr[2]);
                }
            }
            FileSystem.FileClose(2);
        }

        private void AnyDepth(int xc, int yc)
        {

            x1 = xc * Xscale;
            y1 = yc * Yscale;
            i = (int)(xc / (long)Math.Round(dxGrid) + 1L);
            j = (int)(yc / (long)Math.Round(dyGrid) + 1L);
            xr_a = xc - (i - 1) * dxGrid;
            yr_a = yc - (j - 1) * dyGrid;
            tx = xr_a / dxGrid;
            ty = yr_a / dyGrid;

            if (xr_a >= 0d)
                r1 = Depth[i, j] + tx * (Depth[i, j + 1] - Depth[i, j]);
            if (xr_a < 0d)
                r1 = Depth[i, j - 1] + tx * (Depth[i, j] - Depth[i, j - 1]);
            if (yr_a >= 0d)
                r2 = Depth[i + 1, j] + tx * (Depth[i + 1, j + 1] - Depth[i + 1, j]);
            if (yr_a < 0d)
                r2 = Depth[i, j] + tx * (Depth[i + 1, j] - Depth[i, j]);

            depth_xy = Conversions.ToDouble(Strings.Format(r1 + ty * (r2 - r1), "####.##"));

        }
        private void PlotContour()
        {

            FileName = Fname.Text;
            PictureBox1.Image = Image.FromFile(FileName);
            Mapname = Map.Text;

            TerrianGenData();

            str = Interaction.InputBox("是否消去海圖", "是：1 否：0", 1.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            if (Conversion.Val(str) == 1d)
            {
                g.Clear(SystemColors.Control);
            }

            str = Interaction.InputBox("要不要繪網格線", "要：1 不要：0", 1.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            if (Conversion.Val(str) == 1d)
            {
                // 網格線
                pen.Color = Color.LightGray;
                pen.Width = 1f;
                var loopTo = NxGrid - 1;
                for (ix = 0; ix <= loopTo; ix++)
                {
                    xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                    g.DrawLine(pen, xi, 0, xi, crty);
                }
                var loopTo1 = NyGrid - 1;
                for (iy = 0; iy <= loopTo1; iy++)
                {
                    yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                    g.DrawLine(pen, 0, yi, crtx, yi);
                }
                // 格點座標
                myfont = new Font("Century", 6f, FontStyle.Italic);
                var loopTo2 = NxGrid;
                for (ix = 1; ix <= loopTo2; ix++)
                {
                    xi = (int)Math.Round((ix - 1) * crtx / (double)(NxGrid - 1));
                    brush.Color = Color.Gray;
                    g.DrawString(ix.ToString(), myfont, brush, xi, 0f);
                }
                var loopTo3 = NyGrid;
                for (iy = 1; iy <= loopTo3; iy++)
                {
                    yi = (int)Math.Round((iy - 1) * crty / (double)(NyGrid - 1));
                    brush.Color = Color.Gray;
                    g.DrawString(iy.ToString(), myfont, brush, crtx, yi);
                }
                myfont = new Font("Century", 12f, FontStyle.Italic);
            }

            // 港池
            if (layoutline != 0)
            {
                pen.Width = 2f;
                pen.Color = Color.Black;
                var loopTo4 = layoutline;
                for (i = 1; i <= loopTo4; i++)
                {
                    str = i.ToString();
                    fname6 = Mapname + "_" + str + ".layout";
                    FileSystem.FileOpen(2, fname6, OpenMode.Input);

                    var loopTo5 = layout_dki[i];
                    for (dki = 1; dki <= loopTo5; dki++)
                    {
                        str = FileSystem.LineInput(2);
                        substr = Strings.Split(str, ",");
                        x_layout[i, dki] = (int)Math.Round(Conversion.Val(substr[0]));
                        y_layout[i, dki] = (int)Math.Round(Conversion.Val(substr[1]));
                        z_layout[i, dki] = Conversion.Val(substr[2]);
                    }
                    FileSystem.FileClose(2);
                    var loopTo6 = layout_dki[i];
                    for (dki = 2; dki <= loopTo6; dki++)
                    {
                        ix1 = x_layout[i, dki - 1];
                        iy1 = y_layout[i, dki - 1];
                        ix2 = x_layout[i, dki];
                        iy2 = y_layout[i, dki];
                        g.DrawLine(pen, ix1, iy1, ix2, iy2);
                    }
                }
            }

            // 等深線
            if (contourline != 0)
            {
                pen.Width = 1f;
                dot = 2;
                pen.Color = Color.LightGreen;
                var loopTo7 = contourline;
                for (i = 1; i <= loopTo7; i++)
                {
                    str = i.ToString();
                    fname8 = Mapname + "_" + str + ".contour";
                    FileSystem.FileOpen(2, fname8, OpenMode.Input);

                    var loopTo8 = contour_dki[i];
                    for (dki = 1; dki <= loopTo8; dki++)
                    {
                        str = FileSystem.LineInput(2);
                        substr = Strings.Split(str, ",");
                        x_contour[i, dki] = Conversions.ToInteger(substr[0]);
                        y_contour[i, dki] = Conversions.ToInteger(substr[1]);
                        z_contour[i, dki] = Conversions.ToDouble(substr[2]);
                        D = substr[2];
                        xc = x_contour[i, dki];
                        yc = y_contour[i, dki];
                        dep = z_contour[i, dki];
                        if (dki == 2)
                        {
                            str = i.ToString();
                            brush.Color = Color.LightGray;
                            g.DrawString(str, myfont, brush, xc, yc);
                        }
                        if (dki == 10)
                        {
                            brush.Color = Color.LightBlue;
                            g.DrawString(D, myfont, brush, xc, yc);
                        }
                    }
                    FileSystem.FileClose(2);
                    var loopTo9 = contour_dki[i];
                    for (dki = 2; dki <= loopTo9; dki++)
                    {
                        ix1 = x_contour[i, dki - 1];
                        iy1 = y_contour[i, dki - 1];
                        ix2 = x_contour[i, dki];
                        iy2 = y_contour[i, dki];
                        g.DrawLine(pen, ix1, iy1, ix2, iy2);
                    }
                }
            }

        }
        private void Plot_Click(object sender, EventArgs e)
        {

            FileName = Fname.Text;
            PictureBox1.Image = Image.FromFile(FileName);
            Mapname = Map.Text;

            TerrianGenData();

            str = Interaction.InputBox("是否消去海圖", "是：1 否：0", 1.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            if (Conversion.Val(str) == 1d)
            {
                g.Clear(SystemColors.Control);
            }

            str = Interaction.InputBox("要不要繪網格線", "要：1 不要：0", 1.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            if (Conversion.Val(str) == 1d)
            {
                // 網格線
                pen.Color = Color.LightGray;
                pen.Width = 1f;
                var loopTo = NxGrid - 1;
                for (ix = 0; ix <= loopTo; ix++)
                {
                    xi = (int)Math.Round(ix * crtx / (double)(NxGrid - 1));
                    g.DrawLine(pen, xi, 0, xi, crty);
                }
                var loopTo1 = NyGrid - 1;
                for (iy = 0; iy <= loopTo1; iy++)
                {
                    yi = (int)Math.Round(iy * crty / (double)(NyGrid - 1));
                    g.DrawLine(pen, 0, yi, crtx, yi);
                }
                // 格點座標
                myfont = new Font("Century", 6f, FontStyle.Italic);
                var loopTo2 = NxGrid;
                for (ix = 1; ix <= loopTo2; ix++)
                {
                    xi = (int)Math.Round((ix - 1) * crtx / (double)(NxGrid - 1));
                    brush.Color = Color.Gray;
                    g.DrawString(ix.ToString(), myfont, brush, xi, 0f);
                }
                var loopTo3 = NyGrid;
                for (iy = 1; iy <= loopTo3; iy++)
                {
                    yi = (int)Math.Round((iy - 1) * crty / (double)(NyGrid - 1));
                    brush.Color = Color.Gray;
                    g.DrawString(iy.ToString(), myfont, brush, crtx, yi);
                }
                myfont = new Font("Century", 12f, FontStyle.Italic);
            }

            // 港池
            if (layoutline != 0)
            {
                pen.Width = 2f;
                pen.Color = Color.Gray;
                var loopTo4 = layoutline;
                for (i = 1; i <= loopTo4; i++)
                {
                    str = i.ToString();
                    fname6 = Mapname + "_" + str + ".layout";
                    FileSystem.FileOpen(2, fname6, OpenMode.Input);

                    var loopTo5 = layout_dki[i];
                    for (dki = 1; dki <= loopTo5; dki++)
                    {
                        str = FileSystem.LineInput(2);
                        substr = Strings.Split(str, ",");
                        x_layout[i, dki] = (int)Math.Round(Conversion.Val(substr[0]));
                        y_layout[i, dki] = (int)Math.Round(Conversion.Val(substr[1]));
                        z_layout[i, dki] = Conversion.Val(substr[2]);
                    }
                    FileSystem.FileClose(2);
                    var loopTo6 = layout_dki[i];
                    for (dki = 2; dki <= loopTo6; dki++)
                    {
                        ix1 = x_layout[i, dki - 1];
                        iy1 = y_layout[i, dki - 1];
                        ix2 = x_layout[i, dki];
                        iy2 = y_layout[i, dki];
                        g.DrawLine(pen, ix1, iy1, ix2, iy2);
                    }
                }
            }

            // 等深線
            if (contourline != 0)
            {
                pen.Width = 1f;
                dot = 2;
                pen.Color = Color.LightGreen;
                var loopTo7 = contourline;
                for (i = 1; i <= loopTo7; i++)
                {
                    str = i.ToString();
                    fname8 = Mapname + "_" + str + ".contour";
                    FileSystem.FileOpen(2, fname8, OpenMode.Input);

                    var loopTo8 = contour_dki[i];
                    for (dki = 1; dki <= loopTo8; dki++)
                    {
                        str = FileSystem.LineInput(2);
                        substr = Strings.Split(str, ",");
                        x_contour[i, dki] = Conversions.ToInteger(substr[0]);
                        y_contour[i, dki] = Conversions.ToInteger(substr[1]);
                        z_contour[i, dki] = Conversions.ToDouble(substr[2]);
                        D = substr[2];
                        xc = x_contour[i, dki];
                        yc = y_contour[i, dki];
                        dep = z_contour[i, dki];
                        if (dki == 2)
                        {
                            str = i.ToString();
                            brush.Color = Color.LightGray;
                            g.DrawString(str, myfont, brush, xc, yc);
                        }
                        if (dki == 10)
                        {
                            brush.Color = Color.LightBlue;
                            g.DrawString(D, myfont, brush, xc, yc);
                        }
                    }
                    FileSystem.FileClose(2);
                    var loopTo9 = contour_dki[i];
                    for (dki = 2; dki <= loopTo9; dki++)
                    {
                        ix1 = x_contour[i, dki - 1];
                        iy1 = y_contour[i, dki - 1];
                        ix2 = x_contour[i, dki];
                        iy2 = y_contour[i, dki];
                        g.DrawLine(pen, ix1, iy1, ix2, iy2);
                    }
                }
            }

            str = Interaction.InputBox("是否顯示邊界節點", "是：1 否：0", 0.ToString());
            if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
            {
                if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                    return;
            }
            plotYN = (int)Math.Round(Conversion.Val(str));
            if (plotYN == 1)
            {
                str = Interaction.InputBox("是否顯示邊界節點編號", "是：1 否：0", 0.ToString());
                if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
                {
                    if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                        return;
                }
                plotYN = (int)Math.Round(Conversion.Val(str));
                dot = 5;
                brush.Color = Color.Blue;
                if (layoutline != 0)
                {
                    var loopTo10 = layoutline;
                    for (i = 1; i <= loopTo10; i++)
                    {
                        str = i.ToString();
                        fname6 = Mapname + "_" + str + ".quaynode";
                        FileSystem.FileOpen(2, fname6, OpenMode.Input);

                        var loopTo11 = quaynode_dki[i];
                        for (dki = 1; dki <= loopTo11; dki++)
                        {
                            str = FileSystem.LineInput(2);
                            substr = Strings.Split(str, ",");
                            x_quaynode[i, dki] = Conversions.ToInteger(substr[0]);
                            y_quaynode[i, dki] = Conversions.ToInteger(substr[1]);
                        }
                        FileSystem.FileClose(2);
                        var loopTo12 = quaynode_dki[i];
                        for (dki = 1; dki <= loopTo12; dki++)
                        {
                            ppx = x_quaynode[i, dki];
                            ppy = y_quaynode[i, dki];
                            g.FillEllipse(brush, ppx, ppy, dot, dot);
                            if (plotYN == 1)
                            {
                                g.DrawString(dki.ToString(), myfont, brush, ppx, ppy);
                            }
                        }
                    }
                }
            }
        }

        private void Endd_Click(object sender, EventArgs e)
        {

            FileSystem.FileClose(2);
            if (procedure == 11)
            {
                str = Interaction.InputBox("是否繼續執行邊界節點及碼頭水深", "是：1 否：0", 0.ToString());
                if (string.IsNullOrEmpty(str) | Strings.Len(Strings.Trim(str)) == 0)
                {
                    if (Interaction.MsgBox("未輸入資料，是否結束？", (MsgBoxStyle)((int)Constants.vbYesNo + (int)Constants.vbQuestion), "結束詢問") == Constants.vbYes)
                        return;
                }
                plotYN = (int)Math.Round(Conversion.Val(str));
                if (plotYN == 1)
                {
                    QuayNode();
                    if (layoutcount == 1)
                        QuayDepth();
                }
                else
                {
                    return;
                }
            }
            if (proce_num == 10)
            {
                fname6 = Mapname + ".grid";
                FileSystem.FileOpen(6, fname6, OpenMode.Output);
                var loopTo = NxGrid;
                for (ix = 1; ix <= loopTo; ix++)
                {
                    var loopTo1 = NyGrid;
                    for (iy = 1; iy <= loopTo1; iy++)
                    {
                        D = Strings.Format(Depth[ix, iy], "####.##");
                        FileSystem.PrintLine(6, ix + "," + iy + "," + D + "," + "GridDepth");
                    }
                }
                FileSystem.FileClose(6);
            }
        }
        private void All_end_Click(object sender, EventArgs e)
        {
            Contour_append.Visible = true;
            Harborappend.Visible = true;
            DataSave();
            tb_layoutline.Text = layoutline.ToString();
            tb_contourline.Text = contourline.ToString();
        }

        private void EndSeaMap_Click_1(object sender, EventArgs e)
        {
            g.Clear(PictureBox1.BackColor);
            Close();
        }

    }
}